connector BondPort//Base class 
 Real e;
 Real f;
end BondPort;

connector SignalPort//Base class 
 Real s;
end SignalPort;

class Node1//C
 BondPort Port24;
 parameter  Real 	C = 1/50;
 Real 	q(start = -0.1);
equation
 Port24.f = der(q);
 q = C * Port24.e;
end Node1;

class Node2//J1
 BondPort Port25;
 BondPort Port27;
equation
 Port25.f = Port27.f;
 -Port25.e+Port27.e = 0;
end Node2;

class Node3//J0
 BondPort Port28;
 BondPort Port36;
 BondPort Port39;
equation
 Port28.e = Port36.e;
 Port36.e = Port39.e;
 +Port28.f-Port36.f-Port39.f = 0;
end Node3;

class Node4//MTF
 BondPort Port31;
 SignalPort Port48;
 parameter  Real 	MTF6 = 0;
 BondPort Port63;
equation
 Port31.f = 0.1*cos(Port48.s) * Port63.f;
 Port63.e = 0.1*cos(Port48.s) * Port31.e;
end Node4;

class Node5//J0
 BondPort Port30;
 BondPort Port33;
equation
 Port30.e = Port33.e;
 -Port30.f-Port33.f = 0;
end Node5;

class Node6//MTF
 BondPort Port34;
 SignalPort Port96;
 parameter  Real 	MTF5 = 0;
 BondPort Port99;
equation
 Port34.f = 0.2*cos(Port96.s) * Port99.f;
 Port99.e = 0.2*cos(Port96.s) * Port34.e;
end Node6;

class Node7//MTF
 BondPort Port37;
 SignalPort Port45;
 parameter  Real 	MTF1 = 0;
 BondPort Port66;
equation
 Port37.f = 0.1*sin(Port45.s) * Port66.f;
 Port66.e = 0.1*sin(Port45.s) * Port37.e;
end Node7;

class Node8//MTF
 BondPort Port40;
 BondPort Port84;
 SignalPort Port87;
 parameter  Real 	MTF3 = 0;
equation
 Port40.f = 0.2*sin(Port87.s) * Port84.f;
 Port84.e = 0.2*sin(Port87.s) * Port40.e;
end Node8;

class Node9//Integral
 SignalPort Port81;
 Real 	Int(start = 0.7854);
 SignalPort Port88;
 SignalPort Port91;
 SignalPort Port94;
 SignalPort Port97;
 SignalPort Port137;
equation
 Port81.s = der(Int);
 Port88.s =Int;
 Port91.s = Int;
 Port94.s = Int;
 Port97.s = Int;
 Port137.s = Int;
end Node9;

class Node10//Integral
 SignalPort Port42;
 Real 	Int(start = 0.7854);
 SignalPort Port46;
 SignalPort Port49;
 SignalPort Port52;
 SignalPort Port70;
 SignalPort Port125;
equation
 Port42.s = der(Int);
 Port46.s =Int;
 Port49.s =Int;
 Port52.s =Int;
 Port70.s =Int;
 Port125.s = Int;
end Node10;

class Node11//J1
 SignalPort Port43;
 BondPort Port54;
 BondPort Port58;
 BondPort Port61;
 BondPort Port64;
 BondPort Port67;
 BondPort Port121;
equation
 Port54.e-Port58.e-Port61.e-Port64.e-Port67.e-Port121.e = 0;
 Port54.f = Port58.f;
 Port58.f = Port61.f;
 Port61.f = Port64.f;
 Port64.f = Port67.f;
 Port67.f = Port121.f;
 Port121.f = Port43.s;
end Node11;

class Node12//MTF
 SignalPort Port51;
 parameter  Real 	MTF7 = 0;
 BondPort Port60;
 BondPort Port109;
equation
 Port60.e =0.1*cos(Port51.s) * Port109.e;
 Port109.f = 0.1*cos(Port51.s) * Port60.f;
end Node12;

class Node13//MTF
 BondPort Port72;
 SignalPort Port93;
 parameter  Real 	MTF8 = 0;
 BondPort Port112;
equation
 Port72.e = -0.1*sin(Port93.s) * Port112.e;
 Port112.f = -0.1*sin(Port93.s) * Port72.f;
end Node13;

class Node14//J1
 BondPort Port73;
 BondPort Port76;
 BondPort Port79;
 SignalPort Port82;
 BondPort Port85;
 BondPort Port100;
equation
 Port73.f = Port76.f;
 Port76.f = Port79.f;
 Port79.f = Port82.s;
 Port82.s = Port85.f;
 Port85.f = Port100.f;
 -Port73.e-Port76.e-Port79.e-Port85.e-Port100.e = 0;
end Node14;

class Node15//Sf
 BondPort Port55;
 parameter  Real 	Sf = 2.5;
equation
 Port55.f = if time < 0.1 then  Sf*time/0.1 else Sf;
end Node15;

class Node16//I
 BondPort Port57;
 parameter  Real 	I1 = 0.01;
 Real 	p;
equation
 Port57.e = der(p);
 p = I1 * Port57.f;
end Node16;

class Node17//MTF
 SignalPort Port69;
 parameter  Real 	MTF2 = 0;
 BondPort Port106;
 BondPort Port120;
equation
 Port106.f = -0.1*sin(Port69.s) * Port120.f;
 Port120.e = -0.1*sin(Port69.s) * Port106.e;
end Node17;

class Node18//MTF
 BondPort Port75;
 SignalPort Port90;
 parameter  Real 	MTF4 = 0;
 BondPort Port103;
equation
 Port75.e = 0.1*cos(Port90.s) * Port103.e;
 Port103.f = 0.1*cos(Port90.s) * Port75.f;
end Node18;

class Node19//I
 BondPort Port78;
 parameter  Real 	I4 = 0.02;
 Real 	p;
equation
 Port78.e = der(p);
 p = I4 * Port78.f;
end Node19;

class Node20//J0
 BondPort Port105;
 BondPort Port111;
 BondPort Port115;
equation
 Port105.e = Port111.e;
 Port111.e = Port115.e;
 -Port105.f-Port111.f+Port115.f = 0;
end Node20;

class Node21//I
 BondPort Port114;
 parameter  Real 	I2 = 1;
 Real 	p;
equation
 Port114.e = der(p);
 p = I2 * Port114.f;
end Node21;

class Node22//J0
 BondPort Port102;
 BondPort Port108;
 BondPort Port118;
equation
 Port102.e = Port108.e;
 Port108.e = Port118.e;
 -Port102.f-Port108.f+Port118.f = 0;
end Node22;

class Node23//I
 BondPort Port117;
 parameter  Real 	I3 = 1;
 Real 	p;
equation
 Port117.e = der(p);
 p = I3 * Port117.f;
end Node23;

class Node123//Function
 SignalPort Port124;
 SignalPort Port131;
 SignalPort Port134;
 SignalPort Port136;
 SignalPort Port140;
equation
 Port131.s =0.1*cos(Port124.s);
 Port134.s = 0.1*sin(Port124.s);
 Port140.s = 0.1*cos(Port124.s)+0.2*cos(Port136.s);
end Node123;

class Node127//Ds
 SignalPort Port133;
end Node127;

class Node128//Ds
 SignalPort Port130;
end Node128;

class Node129//Ds
 SignalPort Port139;
end Node129;

model modele31
Node1 c_1;
Node2 j1_2;
Node3 j0_3;
Node4 mtf_4;
Node5 j0_5;
Node6 mtf_6;
Node7 mtf_7;
Node8 mtf_8;
Node9 integral_9;
Node10 integral_10;
Node11 j1_11;
Node12 mtf_12;
Node13 mtf_13;
Node14 j1_14;
Node15 sf_15;
Node16 i_16;
Node17 mtf_17;
Node18 mtf_18;
Node19 i_19;
Node20 j0_20;
Node21 i_21;
Node22 j0_22;
Node23 i_23;
Node123 function_123;
Node127 Ya;
Node128 Xa;
Node129 Xb;
equation
 connect(j1_2.Port25,c_1.Port24);
 connect(j0_3.Port28,j1_2.Port27);
 connect(mtf_4.Port31,j0_5.Port30);
 connect(mtf_6.Port34,j0_5.Port33);
 connect(mtf_7.Port37,j0_3.Port36);
 connect(mtf_8.Port40,j0_3.Port39);
 connect(j1_11.Port43,integral_10.Port42);
 connect(integral_10.Port46,mtf_7.Port45);
 connect(integral_10.Port49,mtf_4.Port48);
 connect(integral_10.Port52,mtf_12.Port51);
 connect(sf_15.Port55,j1_11.Port54);
 connect(j1_11.Port58,i_16.Port57);
 connect(j1_11.Port61,mtf_12.Port60);
 connect(j1_11.Port64,mtf_4.Port63);
 connect(j1_11.Port67,mtf_7.Port66);
 connect(integral_10.Port70,mtf_17.Port69);
 connect(j1_14.Port73,mtf_13.Port72);
 connect(j1_14.Port76,mtf_18.Port75);
 connect(j1_14.Port79,i_19.Port78);
 connect(j1_14.Port82,integral_9.Port81);
 connect(j1_14.Port85,mtf_8.Port84);
 connect(integral_9.Port88,mtf_8.Port87);
 connect(integral_9.Port91,mtf_18.Port90);
 connect(integral_9.Port94,mtf_13.Port93);
 connect(integral_9.Port97,mtf_6.Port96);
 connect(j1_14.Port100,mtf_6.Port99);
 connect(mtf_18.Port103,j0_22.Port102);
 connect(mtf_17.Port106,j0_20.Port105);
 connect(mtf_12.Port109,j0_22.Port108);
 connect(mtf_13.Port112,j0_20.Port111);
 connect(j0_20.Port115,i_21.Port114);
 connect(j0_22.Port118,i_23.Port117);
 connect(j1_11.Port121,mtf_17.Port120);
 connect(integral_10.Port125,function_123.Port124);
 connect(function_123.Port131,Xa.Port130);
 connect(function_123.Port134,Ya.Port133);
 connect(integral_9.Port137,function_123.Port136);
 connect(function_123.Port140,Xb.Port139);
end modele31;
